function smooth=KalmanSmoother (T, upd, pred)

%---------- Create matrices-------------------------
smooth=zeros(T+1,2);
smooth(end,:)=upd(end,:);
%---------- Smoothing equation --------------------------
for i=1:T
smooth(T+1-i,1)=upd(T+1-i,1)+upd(T+1-i,2)/pred(T+1-i,2)*(smooth(T+2-i,1)-upd(T+1-i,1));
smooth(T+1-i,2)=upd(T+1-i,2)+upd(T+1-i,2)/pred(T+1-i,2)*(smooth(T+2-i,2)-pred(T+1-i,2))/pred(T+1-i,2)*upd(T+1-i,2);
end;